import { drizzle } from 'drizzle-orm/postgres-js';
import postgres from 'postgres';
import * as schema from "@shared/schema";

// AWS sunucusunda lokal PostgreSQL kullan, Replit'te ise mevcut DATABASE_URL'i kullan
const isAWSServer = process.env.NODE_ENV === 'production' && !process.env.DATABASE_URL?.includes('neon.tech');
const databaseUrl = isAWSServer 
  ? 'postgresql://jouska:jouska2024@localhost:5432/jouska_menu'
  : process.env.DATABASE_URL;

if (!databaseUrl) {
  throw new Error('Database URL not configured');
}

console.log(isAWSServer ? 'Using local AWS PostgreSQL' : 'Using Replit database');

const client = postgres(databaseUrl, {
  ssl: databaseUrl.includes('neon.tech') ? 'require' : false,
  max: 10,
  idle_timeout: 20
});

export const db = drizzle(client, { schema });