import { drizzle } from 'drizzle-orm/mysql2';
import mysql from 'mysql2/promise';
import * as schema from "@shared/schema-mysql";

if (!process.env.DATABASE_URL) {
  throw new Error(
    "DATABASE_URL must be set. Did you forget to provision a database?",
  );
}

export const pool = mysql.createPool({
  host: process.env.MYSQL_HOST || 'localhost',
  user: process.env.MYSQL_USER || 'jouska_user',
  password: process.env.MYSQL_PASSWORD || 'jouska_2024',
  database: process.env.MYSQL_DATABASE || 'jouska_db',
  port: 3306,
  connectionLimit: 10,
});

export const db = drizzle(pool, { schema, mode: 'default' });