# Localhost phpMyAdmin ile Jouska Veritabanı Kurulumu

## Localhost Bağlantı Bilgileri
- **Adres:** http://localhost:8080
- **MySQL Sunucu:** mysql (veya localhost)
- **Kullanıcı:** jouska_user
- **Şifre:** jouska_2024
- **Veritabanı:** jouska_db

## 1. Veritabanı Oluşturma

1. http://localhost:8080 adresinden phpMyAdmin'e giriş yapın
2. Kullanıcı adı: `jouska_user`, Şifre: `jouska_2024`
3. Sol menüden "Yeni" butonuna tıklayın
4. Veritabanı adı: `jouska_db`
5. Karakter seti: `utf8mb4_unicode_ci`
6. "Oluştur" butonuna tıklayın

## 2. SQL Dosyasını İçe Aktarma

1. `jouska_db` veritabanını seçin
2. Üst menüden "İçe Aktar" (Import) sekmesine tıklayın
3. "Dosya seç" butonuna tıklayın
4. `jouska_mysql_dump.sql` dosyasını seçin
5. "Git" (Go) butonuna tıklayın

**Not:** Eğer veri kayıt işlemi yapamıyorsanız:

1. **Yetki Problemi Çözümü:**
   - phpMyAdmin'de SQL sekmesine gidin
   - Bu komutu çalıştırın:
   ```sql
   GRANT ALL PRIVILEGES ON jouska_db.* TO 'jouska_user'@'localhost';
   FLUSH PRIVILEGES;
   ```

2. **Alternatif Çözüm:**
   - Root kullanıcısı ile giriş yapın
   - Kullanıcı yetkilerini tam verin:
   ```sql
   GRANT ALL PRIVILEGES ON *.* TO 'jouska_user'@'localhost' WITH GRANT OPTION;
   FLUSH PRIVILEGES;
   ```

## 3. Varsayılan Veriler

SQL dosyası aşağıdaki varsayılan verileri içerir:

### Admin Kullanıcısı
- **Kullanıcı adı:** admin
- **Şifre:** admin123

### Restaurant Bilgileri
- **Ad:** Jouska Cafe & Restaurant
- **Sipariş sistemi:** Kapalı (admin panelden açılabilir)

### Tema
- **Varsayılan tema:** Turuncu renk teması aktif

### SEO Ayarları
- **Temel SEO** ayarları yapılandırılmış

## 4. Localhost Bağlantı Ayarları

.env dosyanızda:
```
MYSQL_HOST=mysql
MYSQL_USER=jouska_user
MYSQL_PASSWORD=jouska_2024
MYSQL_DATABASE=jouska_db
SESSION_SECRET=localhost-session-secret-2024
```

**Localhost için alternatif ayar:**
```
MYSQL_HOST=localhost
MYSQL_USER=jouska_user
MYSQL_PASSWORD=jouska_2024
MYSQL_DATABASE=jouska_db
SESSION_SECRET=localhost-session-secret-2024
```

## 5. Doğrulama

Import işlemi tamamlandıktan sonra:
- 18 tablo oluşturulmuş olmalı
- Admin user, restaurant, theme ve SEO ayarları hazır
- Sistem admin panelden yönetilebilir durumda