# Localhost Development Setup

## Gerekli Dosya Değişiklikleri

### 1. .env Dosyası
```
MYSQL_HOST=mysql
MYSQL_USER=jouska_user
MYSQL_PASSWORD=jouska_2024
MYSQL_DATABASE=jouska_db
SESSION_SECRET=localhost-session-secret-2024
```

### 2. server/index.ts ve server/routes.ts
MySQL import'ları aktif olduğundan emin olun:

**server/index.ts:**
```javascript
// MySQL migration (production - aktif)
import { runMigrations } from "./migrate-mysql";
```

**server/routes.ts:**
```javascript
// MySQL storage (production - aktif)
import { storage } from "./database-storage-mysql";
```

## Localhost Test Adımları

1. **phpMyAdmin:** http://localhost:8080
   - Kullanıcı: jouska_user
   - Şifre: jouska_2024

2. **Veritabanı oluştur:** jouska_db

3. **SQL import:** jouska_mysql_dump.sql

4. **Uygulama başlat:**
   ```bash
   npm install
   npm run dev
   ```

5. **Test:**
   - Frontend: http://localhost:5000
   - Admin: http://localhost:5000/admin
   - Giriş: admin/admin123

## Sorun Giderme

### Veri kayıt sorunu çözümü:

1. **Yetki Problemi:**
   ```sql
   GRANT ALL PRIVILEGES ON jouska_db.* TO 'jouska_user'@'localhost';
   FLUSH PRIVILEGES;
   ```

2. **Tablo kontrol:**
   ```sql
   USE jouska_db;
   SHOW TABLES;
   DESCRIBE users;
   ```

3. **Test verisi ekleme:**
   ```sql
   INSERT INTO users (username, password) VALUES ('test', 'test123');
   SELECT * FROM users WHERE username = 'test';
   ```

4. **Bağlantı testi:**
   - Console log'larını kontrol edin
   - MySQL servisinin çalıştığından emin olun
   - Port 3306'nın açık olduğunu kontrol edin

### Host ayarı alternatifi:
Eğer 'mysql' host çalışmazsa .env'de:
```
MYSQL_HOST=localhost
```
veya
```
MYSQL_HOST=127.0.0.1
```
deneyin.