import { useQuery } from "@tanstack/react-query";
import { MenuItem } from "@shared/schema";
import { 
  getCachedMenuItems, 
  cacheMenuItems
} from "@/lib/offline-storage";

export function useMenuItems() {
  const query = useQuery<MenuItem[]>({
    queryKey: ['/api/menu-items'],
    staleTime: 1000 * 60 * 5 // 5 minutes
  });
  
  // Handle success and cache data
  if (query.data && query.data.length > 0) {
    cacheMenuItems(query.data);
  }
  
  return query;
}

export function useMenuItemsByCategory(categoryId: number) {
  return useQuery<MenuItem[]>({
    queryKey: ['/api/categories', categoryId, 'menu-items'],
    enabled: !!categoryId,
  });
}

export function useCompleteMenu() {
  return useQuery<Array<{ id: number; name: string; slug: string; order: number; items: MenuItem[] }>>({
    queryKey: ['/api/menu'],
  });
}
