import { Button } from "@/components/ui/button";
import { Star, ExternalLink } from "lucide-react";
import { Badge } from "@/components/ui/badge";

interface GoogleReviewsButtonProps {
  googleMyBusinessUrl?: string | null;
  googlePlaceId?: string | null;
  restaurantName?: string;
  className?: string;
}

export function GoogleReviewsButton({ 
  googleMyBusinessUrl, 
  googlePlaceId, 
  restaurantName = "Jouska Cafe & Restaurant",
  className = ""
}: GoogleReviewsButtonProps) {
  
  // Google yorumlara yönlendirme URL'si oluştur
  const getReviewUrl = () => {
    if (googleMyBusinessUrl) {
      return googleMyBusinessUrl;
    }
    
    if (googlePlaceId) {
      return `https://search.google.com/local/writereview?placeid=${googlePlaceId}`;
    }
    
    // Fallback: Restaurant adı ile arama
    const searchQuery = encodeURIComponent(restaurantName);
    return `https://www.google.com/maps/search/?api=1&query=${searchQuery}`;
  };

  const handleReviewClick = () => {
    window.open(getReviewUrl(), '_blank');
  };

  return (
    <div className={`flex flex-col space-y-3 ${className}`}>
      <div className="flex items-center justify-between">
        <h3 className="text-lg font-semibold text-gray-900">Görüşlerinizi Paylaşın</h3>
        <Badge variant="secondary" className="flex items-center space-x-1">
          <Star className="w-3 h-3 fill-yellow-400 text-yellow-400" />
          <span>Google</span>
        </Badge>
      </div>
      
      <p className="text-sm text-gray-600">
        Deneyiminizi Google'da paylaşarak diğer müşterilere yardımcı olun
      </p>
      
      <Button 
        onClick={handleReviewClick}
        className="w-full bg-blue-600 hover:bg-blue-700 text-white flex items-center justify-center space-x-2"
        size="lg"
      >
        <Star className="w-4 h-4" />
        <span>Google'da Yorumla</span>
        <ExternalLink className="w-4 h-4" />
      </Button>
      
      <div className="flex items-center justify-center space-x-4 text-xs text-gray-500">
        <div className="flex items-center space-x-1">
          <div className="flex">
            {[1, 2, 3, 4, 5].map((star) => (
              <Star 
                key={star} 
                className="w-3 h-3 fill-yellow-400 text-yellow-400" 
              />
            ))}
          </div>
          <span>5 yıldız verin</span>
        </div>
      </div>
    </div>
  );
}