import React from "react";
import { MenuItemCard } from "./menu-item";
import { MenuItem } from "@shared/schema";
import { SectionTitle } from "@/components/ui/section-title";
import { Link } from "wouter";
import { Button } from "@/components/ui/button";
import { ArrowRight } from "lucide-react";

interface MenuCategoryProps {
  id: string;
  title: string;
  items: MenuItem[];
}

export const MenuCategory = ({ id, title, items }: MenuCategoryProps) => {
  return (
    <section id={id} className="category-section mb-6 pt-4 sm:pt-6 scroll-mt-[140px]">
      <div className="relative">
        {/* Category title with elegant design using SectionTitle component */}
        <div className="flex items-center mb-5 group relative z-10">
          <div className="flex-grow">
            <SectionTitle 
              title={title}
              subtitle={`${items.length} ${items.length === 1 ? 'ürün' : 'ürün'}`}
              size="md"
              decorative={true}
              titleClassName="text-primary group-hover:text-accent transition-colors duration-300"
              subtitleClassName="text-xs text-muted-foreground"
            />
            
            <Link href={`/category/${id}`} className="ml-4">
              <Button 
                variant="ghost" 
                size="sm"
                className="text-primary hover:text-accent hover:bg-primary/5 transition-colors"
              >
                <span className="mr-1">Tümünü Gör</span>
                <ArrowRight className="h-4 w-4" />
              </Button>
            </Link>
          </div>
          
          {/* Decorative line */}
          <div className="w-1/4 h-px bg-border ml-6"></div>
        </div>
        
        {/* Background decorative element */}
        <div className="absolute top-0 right-0 w-32 h-32 bg-accent/5 dark:bg-accent/10 rounded-full -translate-y-1/2 translate-x-1/2 blur-3xl"></div>
      </div>
      
      {/* Menu items grid with responsive layout */}
      <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
        {items.filter(item => item.isActive).length > 0 ? (
          items.filter(item => item.isActive).map((item) => (
            <MenuItemCard key={item.id} item={item} />
          ))
        ) : (
          <div className="col-span-2 py-12 text-center">
            <div className="inline-block p-6 rounded-lg bg-primary/5 dark:bg-primary/10 text-primary">
              <svg xmlns="http://www.w3.org/2000/svg" className="h-12 w-12 mx-auto mb-4 opacity-50" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={1} d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
              </svg>
              <p className="text-lg font-medium mb-2">Bu kategoride henüz ürün bulunmamaktadır</p>
              <p className="text-sm text-muted-foreground">Çok yakında yeni ürünler eklenecektir.</p>
            </div>
          </div>
        )}
      </div>
    </section>
  );
};
