import { useState } from "react";
import { Button } from "@/components/ui/button";
import { Badge } from "@/components/ui/badge";
import { ShoppingCart } from "lucide-react";
import { useCart } from "@/hooks/use-cart";
import { ShoppingCart as ShoppingCartModal } from "./shopping-cart";
import { motion, AnimatePresence } from "framer-motion";

export function CartButton() {
  const [isCartOpen, setIsCartOpen] = useState(false);
  const { totalItems, totalPrice } = useCart();

  if (totalItems === 0) return null;

  return (
    <>
      <motion.div
        initial={{ scale: 0 }}
        animate={{ scale: 1 }}
        className="fixed bottom-6 right-6 z-40"
      >
        <Button
          onClick={() => setIsCartOpen(true)}
          className="relative bg-orange-500 hover:bg-orange-600 text-white shadow-lg rounded-full p-4 h-auto"
        >
          <ShoppingCart className="w-6 h-6" />
          <Badge 
            variant="destructive" 
            className="absolute -top-2 -right-2 min-w-[24px] h-6 rounded-full flex items-center justify-center"
          >
            {totalItems}
          </Badge>
          <div className="ml-2 text-sm font-medium">
            ₺{totalPrice.toFixed(2)}
          </div>
        </Button>
      </motion.div>

      <AnimatePresence>
        {isCartOpen && (
          <ShoppingCartModal
            isOpen={isCartOpen}
            onClose={() => setIsCartOpen(false)}
          />
        )}
      </AnimatePresence>
    </>
  );
}