# Jouska Cafe & Restaurant - QR Menu System

Professional restaurant QR menu system with advanced content management and intelligent user experience features.

## Features

### 🍽️ Menu Management
- Dynamic category and menu item management
- Real-time price updates
- Image gallery for menu items
- Allergen and dietary information
- Popular items highlighting

### 🤖 Intelligent Chatbot
- AI-powered customer assistance
- Category navigation
- Q&A management system
- Quick replies and suggestions
- Mobile-responsive interface

### 🎨 Theme Customization
- Complete visual customization
- Color scheme management
- Typography selection
- Mobile-first responsive design
- Dark/Light theme support

### 👨‍💼 Admin Panel
- Secure authentication system
- Content management dashboard
- Restaurant information management
- Feature toggles (order system, reservations, social media)
- Real-time content updates

### 🌐 Multi-language Support
- Turkish language interface
- Internationalization ready
- Localized content management

## Technology Stack

- **Frontend**: React 18, TypeScript, Tailwind CSS
- **Backend**: Node.js, Express, TypeScript
- **Database**: MySQL with Drizzle ORM
- **Deployment**: Docker, Nginx
- **Authentication**: Passport.js with session management
- **UI Components**: Radix UI, shadcn/ui

## Quick Start

### Prerequisites
- Node.js 18+
- MySQL 8.0+
- Docker (for deployment)

### Development Setup
```bash
npm install
npm run dev
```

### Production Deployment
```bash
# AWS/Server deployment
./deploy.sh

# Manual setup
docker-compose up -d
```

## Deployment

The system is optimized for AWS deployment with:
- 2GB RAM server configuration
- MySQL database with performance tuning
- Nginx reverse proxy
- SSL-ready configuration
- phpMyAdmin for database management

### Server Access
- **Application**: http://YOUR_SERVER_IP
- **Admin Panel**: http://YOUR_SERVER_IP/admin
- **Database Admin**: http://YOUR_SERVER_IP/phpmyadmin

### Default Credentials
- **Admin Username**: admin
- **Admin Password**: admin123
- **Database**: jouska_db / jouska_user / jouska_2024

## Project Structure

```
├── client/           # React frontend application
├── server/           # Express backend API
├── shared/           # Shared TypeScript schemas
├── mysql-config/     # Database configuration
├── mysql-init/       # Database initialization scripts
├── docker-compose.yml # Docker deployment configuration
└── deploy.sh         # Automated deployment script
```

## Features in Detail

### Restaurant Management
- Complete restaurant information management
- Operating hours configuration
- Contact details and social media links
- Logo and branding customization

### Menu System
- Hierarchical category organization
- Rich menu item descriptions
- Price management with currency formatting
- Availability status tracking
- Preparation time estimates

### Customer Experience
- QR code menu access
- Mobile-optimized interface
- Fast loading and offline capabilities
- Interactive chatbot assistance
- Social sharing integration

### Analytics & Insights
- Menu performance tracking
- Popular items identification
- Customer interaction analytics
- Content management insights

## Security Features

- Secure admin authentication
- Session management
- SQL injection prevention
- XSS protection
- CSRF protection
- Secure file uploads

## Performance Optimizations

- Optimized for 2GB RAM servers
- Database query optimization
- Image compression and lazy loading
- CDN-ready static assets
- Efficient caching strategies

## Support

For technical support and customization requests, please refer to the deployment documentation and configuration guides included in the project.

## License

MIT License - see LICENSE file for details.